<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.22
 */

if (!defined("REVIRTA_THEME_FREE")) define("REVIRTA_THEME_FREE", false);
if (!defined("REVIRTA_THEME_FREE_WP")) define("REVIRTA_THEME_FREE_WP", false);

// Theme storage
$REVIRTA_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins' => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'					=> esc_html__('ThemeREX Addons', 'revirta'),

			// Recommended (supported) plugins fot both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'contact-form-7'				=> esc_html__('Contact Form 7', 'revirta')
		),

		// List of plugins for PREMIUM version only
		//-----------------------------------------------------
		REVIRTA_THEME_FREE 
			? array(
					// Recommended (supported) plugins for the FREE (lite) version
					'siteorigin-panels'			=> esc_html__('SiteOrigin Panels', 'revirta'),
					) 
			: array(
					// Recommended (supported) plugins for the PRO (full) version
					// If plugin not need - comment (or remove) it
					'essential-grid'			=> esc_html__('Essential Grid', 'revirta'),
					'revslider'					=> esc_html__('Revolution Slider', 'revirta'),
					'js_composer'				=> esc_html__('Visual Composer', 'revirta'),
					'vc-extensions-bundle'		=> esc_html__('Visual Composer extensions bundle', 'revirta')
				)
	),
	
	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'	=> 'http://revirta.ancorathemes.com',
	'theme_doc_url'		=> 'http://revirta.ancorathemes.com/doc',
	'theme_download_url'=> 'http://ancorathemes.com',

	'theme_support_url'	=> 'http://ancorathemes.ticksy.com',							// Ancora

	'theme_video_url'	=> 'https://www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',	// Ancora
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('revirta_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'revirta_customizer_theme_setup1', 1 );
	function revirta_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		revirta_storage_set('settings', array(
			
			'duplicate_options'		=> 'child',		// none  - use separate options for template and child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes
			
			'custmize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame
		
			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts
		
			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'
			
			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:
													// vc (default) - standard VC icons selector (very slow and don't support images)
													// internal - internal popup with plugin's or theme's icons list (fast)
			'check_min_version'		=> true,		// Check if exists a .min version of .css and .js and return path to it
													// instead the path to the original file
													// (if debug_mode is off and modification time of the original file < time of the .min file)
			'autoselect_menu'		=> false,		// Show any menu if no menu selected in the location 'main_menu'
													// (for example, the theme is just activated)
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'tgmpa_upload'			=> false		// Allow upload not pre-packaged plugins via TGMPA
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		revirta_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Montserrat',
				'family' => 'sans-serif'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		revirta_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		revirta_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'revirta'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '16px',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '27px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.33px',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.5em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '3em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.13em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-1px',
				'margin-top'		=> '9.4rem',
				'margin-bottom'		=> '3.5rem'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '2.25em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.29em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.7px',
                'margin-top'		=> '9.4rem',
                'margin-bottom'		=> '3rem'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1.875em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.6px',
                'margin-top'		=> '9.4rem',
                'margin-bottom'		=> '2.9rem'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1.5em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.5px',
                'margin-top'		=> '9.5rem',
                'margin-bottom'		=> '2.4rem'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1.125em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.37px',
                'margin-top'		=> '9.65rem',
                'margin-bottom'		=> '2.3rem'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.7em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.32px',
                'margin-top'		=> '9.5rem',
                'margin-bottom'		=> '1.7rem'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'revirta'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1.125em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'revirta'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'revirta'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',	// Attention! Firefox don't allow line-height less then 1.5em in the select
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'revirta'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'revirta'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> '-0.1px'
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'revirta'),
				'description'		=> esc_html__('Font settings of the main menu items', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '16px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'revirta'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'revirta'),
				'font-family'		=> '"Montserrat",sans-serif',
				'font-size' 		=> '16px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		revirta_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> __('Main', 'revirta'),
							'description'	=> __('Colors of the main content area', 'revirta')
							),
			'alter'	=> array(
							'title'			=> __('Alter', 'revirta'),
							'description'	=> __('Colors of the alternative blocks (sidebars, etc.)', 'revirta')
							),
			'extra'	=> array(
							'title'			=> __('Extra', 'revirta'),
							'description'	=> __('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'revirta')
							),
			'inverse' => array(
							'title'			=> __('Inverse', 'revirta'),
							'description'	=> __('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'revirta')
							),
			'input'	=> array(
							'title'			=> __('Input', 'revirta'),
							'description'	=> __('Colors of the form fields (text field, textarea, select, etc.)', 'revirta')
							),
			)
		);
		revirta_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> __('Background color', 'revirta'),
							'description'	=> __('Background color of this block in the normal state', 'revirta')
							),
			'bg_hover'	=> array(
							'title'			=> __('Background hover', 'revirta'),
							'description'	=> __('Background color of this block in the hovered state', 'revirta')
							),
			'bd_color'	=> array(
							'title'			=> __('Border color', 'revirta'),
							'description'	=> __('Border color of this block in the normal state', 'revirta')
							),
			'bd_hover'	=>  array(
							'title'			=> __('Border hover', 'revirta'),
							'description'	=> __('Border color of this block in the hovered state', 'revirta')
							),
			'text'		=> array(
							'title'			=> __('Text', 'revirta'),
							'description'	=> __('Color of the plain text inside this block', 'revirta')
							),
			'text_dark'	=> array(
							'title'			=> __('Text dark', 'revirta'),
							'description'	=> __('Color of the dark text (bold, header, etc.) inside this block', 'revirta')
							),
			'text_light'=> array(
							'title'			=> __('Text light', 'revirta'),
							'description'	=> __('Color of the light text (post meta, etc.) inside this block', 'revirta')
							),
			'text_link'	=> array(
							'title'			=> __('Link', 'revirta'),
							'description'	=> __('Color of the links inside this block', 'revirta')
							),
			'text_hover'=> array(
							'title'			=> __('Link hover', 'revirta'),
							'description'	=> __('Color of the hovered state of links inside this block', 'revirta')
							),
			'text_link2'=> array(
							'title'			=> __('Link 2', 'revirta'),
							'description'	=> __('Color of the accented texts (areas) inside this block', 'revirta')
							),
			'text_hover2'=> array(
							'title'			=> __('Link 2 hover', 'revirta'),
							'description'	=> __('Color of the hovered state of accented texts (areas) inside this block', 'revirta')
							),
			'text_link3'=> array(
							'title'			=> __('Link 3', 'revirta'),
							'description'	=> __('Color of the other accented texts (buttons) inside this block', 'revirta')
							),
			'text_hover3'=> array(
							'title'			=> __('Link 3 hover', 'revirta'),
							'description'	=> __('Color of the hovered state of other accented texts (buttons) inside this block', 'revirta')
							)
			)
		);
		revirta_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'revirta'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',   //
					'bd_color'			=> '#ebebec',   //
		
					// Text and links colors
					'text'				=> '#76787d',   //
					'text_light'		=> '#95979a',   //
					'text_dark'			=> '#42464e',   //
					'text_link'			=> '#57b957',   //  green
					'text_hover'		=> '#3c3f45',   //  dark
					'text_link2'		=> '#51a452',   //
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#f7f8f9',   //
					'alter_bg_hover'	=> '#edf0f2',   //
					'alter_bd_color'	=> '#e5e5e5',
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#a8a9ac',   //
					'alter_light'		=> '#adaeb1',   //
					'alter_dark'		=> '#1d1d1d',
					'alter_link'		=> '#57b957',
					'alter_hover'		=> '#3c3f45',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#2f3339',   //
					'extra_bg_hover'	=> '#44484d',   //
					'extra_bd_color'	=> '#3d3d3d',   //
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#c7c7c9',   //
					'extra_light'		=> '#afafaf',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#3c3f45',
					'extra_hover'		=> '#57b957',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#f7f8f9',   //
					'input_bg_hover'	=> '#f7f8f9',   //
					'input_bd_color'	=> '#f7f8f9',   //
					'input_bd_hover'	=> '#57b957',   //
					'input_text'		=> '#9da0a3',   //
					'input_light'		=> '#9da0a3',   //
					'input_dark'		=> '#42464e',   //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'revirta'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#2f3339',   //
					'bd_color'			=> '#2e2c33',
		
					// Text and links colors
					'text'				=> '#95979a',   //
					'text_light'		=> '#95979a',   //
					'text_dark'			=> '#ffffff',
                    'text_link'			=> '#57b957',   //  green
                    'text_hover'		=> '#ffffff',   //  dark
					'text_link2'		=> '#51a452',   //
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#2f3339',
					'alter_bg_hover'	=> '#333333',
					'alter_bd_color'	=> '#464646',
					'alter_bd_hover'	=> '#4a4a4a',
					'alter_text'		=> '#a6a6a6',
					'alter_light'		=> '#ffffff',   //
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#57b957',
					'alter_hover'		=> '#57b957',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#2f3339',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#464646',
					'extra_bd_hover'	=> '#4a4a4a',
					'extra_text'		=> '#a6a6a6',
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#57b957',
					'extra_hover'		=> '#57b957',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#44484d',   //
					'input_bg_hover'	=> '#44484d',   //
					'input_bd_color'	=> '#44484d',   //
					'input_bd_hover'	=> '#57b957',   //
					'input_text'		=> '#ffffff',   //
					'input_light'		=> '#ffffff',   //
					'input_dark'		=> '#ffffff',   //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1d1d1d',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
		
		// Simple schemes substitution
		revirta_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		revirta_storage_set('scheme_colors_add', array(
			'bg_color_0'		=> array('color' => 'bg_color',			'alpha' => 0),
			'bg_color_02'		=> array('color' => 'bg_color',			'alpha' => 0.2),
			'bg_color_07'		=> array('color' => 'bg_color',			'alpha' => 0.7),
			'bg_color_08'		=> array('color' => 'bg_color',			'alpha' => 0.8),
			'bg_color_09'		=> array('color' => 'bg_color',			'alpha' =>  0.9),
			'alter_bg_color_07'	=> array('color' => 'alter_bg_color',	'alpha' => 0.7),
			'alter_bg_color_04'	=> array('color' => 'alter_bg_color',	'alpha' => 0.4),
			'alter_bg_color_02'	=> array('color' => 'alter_bg_color',	'alpha' => 0.2),
			'alter_bd_color_02'	=> array('color' => 'alter_bd_color',	'alpha' => 0.2),
			'extra_bg_color_07'	=> array('color' => 'extra_bg_color',	'alpha' => 0.7),
			'inverse_link_01'		=> array('color' => 'inverse_link',		'alpha' => 0.1),
			'inverse_link_05'		=> array('color' => 'inverse_link',		'alpha' => 0.5),
			'inverse_link_07'		=> array('color' => 'inverse_link',		'alpha' => 0.7),
			'inverse_link_08'		=> array('color' => 'inverse_link',		'alpha' => 0.8),
			'text_dark_01'		=> array('color' => 'text_dark',		'alpha' => 0.1),
			'text_dark_03'		=> array('color' => 'text_dark',		'alpha' => 0.3),
			'text_dark_04'		=> array('color' => 'text_dark',		'alpha' => 0.4),
			'text_dark_05'		=> array('color' => 'text_dark',		'alpha' => 0.5),
			'text_dark_07'		=> array('color' => 'text_dark',		'alpha' => 0.7),
			'text_dark_08'		=> array('color' => 'text_dark',		'alpha' => 0.8),
			'text_dark_075'		=> array('color' => 'text_dark',		'alpha' => 0.75),
			'text_link_02'		=> array('color' => 'text_link',		'alpha' => 0.2),
			'text_link_07'		=> array('color' => 'text_link',		'alpha' => 0.7),
			'text_link_blend'	=> array('color' => 'text_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5),
			'alter_link_blend'	=> array('color' => 'alter_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		revirta_storage_set('theme_thumbs', apply_filters('revirta_filter_add_thumb_sizes', array(
			'revirta-thumb-huge'		=> array(
												'size'	=> array(1170, 658, true),
												'title' => esc_html__( 'Huge image', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-huge'
												),
			'revirta-thumb-big' 		=> array(
												'size'	=> array( 770, 501, true),
												'title' => esc_html__( 'Large image', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-big'
												),

			'revirta-thumb-med' 		=> array(
												'size'	=> array( 370, 208, true),
												'title' => esc_html__( 'Medium image', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-medium'
												),

                'revirta-thumb-team' 		=> array(
                    'size'	=> array( 370, 370, true),
                    'title' => esc_html__( 'Team image', 'revirta' ),
                    'subst'	=> 'trx_addons-thumb-team'
                ),

			'revirta-thumb-tiny' 		=> array(
												'size'	=> array(  180,  180, true),
												'title' => esc_html__( 'Small square avatar', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-tiny'
												),

			'revirta-thumb-masonry-big' => array(
												'size'	=> array( 760,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry Large (scaled)', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-masonry-big'
												),

			'revirta-thumb-masonry'		=> array(
												'size'	=> array( 370,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry (scaled)', 'revirta' ),
												'subst'	=> 'trx_addons-thumb-masonry'
												)
			))
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'revirta_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'revirta_importer_set_options', 9 );
	function revirta_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url(revirta_get_protocol() . '://revirta.ancorathemes.com/demo/');
			// Required plugins
			$options['required_plugins'] = array_keys(revirta_storage_get('required_plugins'));
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title'] = esc_html__('Revirta Demo', 'revirta');
			$options['files']['default']['domain_dev'] = esc_url(revirta_get_protocol().'://rva.dv.ancorathemes.com');		// Developers domain
			$options['files']['default']['domain_demo']= esc_url(revirta_get_protocol().'://revirta.ancorathemes.com');		// Demo-site domain

			// Banners
			$options['banners'] = array(
				array(
					'image' => revirta_get_file_url('theme-specific/theme.about/images/frontpage.png'),
					'title' => esc_html__('Front page Builder', 'revirta'),
					'content' => wp_kses_post(__('Create your Frontpage right in WordPress Customizer! To do this, you will not need either the Visual Composer or any other Builder. Just turn on/off sections, and fill them with content and decorate to your liking', 'revirta')),
					'link_url' => esc_url('//www.youtube.com/watch?v=VT0AUbMl_KA'),
					'link_caption' => esc_html__('More about Frontpage Builder', 'revirta'),
					'duration' => 20
					),
				array(
					'image' => revirta_get_file_url('theme-specific/theme.about/images/layouts.png'),
					'title' => esc_html__('Custom layouts', 'revirta'),
					'content' => wp_kses_post(__('Forget about problems with customization of header or footer! You can edit any layout without any changes in CSS or HTML, directly in Visual Builder. Moreover - you can easily create your own headers and footers and use them along with built-in', 'revirta')),
					'link_url' => esc_url('//www.youtube.com/watch?v=pYhdFVLd7y4'),
					'link_caption' => esc_html__('More about Custom Layouts', 'revirta'),
					'duration' => 20
					),
				array(
					'image' => revirta_get_file_url('theme-specific/theme.about/images/documentation.png'),
					'title' => esc_html__('Read full documentation', 'revirta'),
					'content' => wp_kses_post(__('Need more details? Please check our full online documentation for detailed information on how to use Revirta', 'revirta')),
					'link_url' => esc_url(revirta_storage_get('theme_doc_url')),
					'link_caption' => esc_html__('Online documentation', 'revirta'),
					'duration' => 15
					),
				array(
					'image' => revirta_get_file_url('theme-specific/theme.about/images/video-tutorials.png'),
					'title' => esc_html__('Video tutorials', 'revirta'),
					'content' => wp_kses_post(__('No time for reading documentation? Check out our video tutorials and learn how to customize Revirta in detail.', 'revirta')),
					'link_url' => esc_url(revirta_storage_get('theme_video_url')),
					'link_caption' => esc_html__('Video tutorials', 'revirta'),
					'duration' => 15
					),
				array(
					'image' => revirta_get_file_url('theme-specific/theme.about/images/studio.png'),
					'title' => esc_html__('Mockingbird Website Custom studio', 'revirta'),
					'content' => wp_kses_post(__('We can make a website based on this theme for a very fair price.
We can implement any extra functional: translate your website, WPML implementation and many other customization according to your request.', 'revirta')),
					'link_url' => esc_url('//mockingbird.ticksy.com/'),
					'link_caption' => esc_html__('Contact us', 'revirta'),
					'duration' => 25
					)
				);
		}
		return $options;
	}
}




// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('revirta_create_theme_options')) {

	function revirta_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __('<b>Attention!</b> Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'revirta');

		revirta_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'revirta'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo in the header', 'revirta'),
				"desc" => '',
				"priority" => 20,
				"type" => "info",
				),
			'logo_text' => array(
				"title" => esc_html__('Use Site Name as Logo', 'revirta'),
				"desc" => wp_kses_data( __('Use the site title and tagline as a text logo if no image is selected', 'revirta') ),
				"class" => "revirta_column-1_2 revirta_new_row",
				"priority" => 30,
				"std" => 1,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_retina_enabled' => array(
				"title" => esc_html__('Allow retina display logo', 'revirta'),
				"desc" => wp_kses_data( __('Show fields to select logo images for Retina display', 'revirta') ),
				"class" => "revirta_column-1_2",
				"priority" => 40,
				"refresh" => false,
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_max_height' => array(
				"title" => esc_html__('Logo max. height', 'revirta'),
				"desc" => wp_kses_data( __("Max. height of the logo image (in pixels). Maximum size of logo depends on the actual size of the picture", 'revirta') ),
				"std" => 80,
				"min" => 20,
				"max" => 160,
				"step" => 1,
				"refresh" => false,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "slider"
				),
			// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'revirta') ),
				"class" => "revirta_column-1_2",
				"priority" => 70,
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile_header' => array(
				"title" => esc_html__('Logo for the mobile header', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'revirta') ),
				"class" => "revirta_column-1_2 revirta_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_header_retina' => array(
				"title" => esc_html__('Logo for the mobile header for Retina', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'revirta') ),
				"class" => "revirta_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'revirta') ),
				"class" => "revirta_column-1_2 revirta_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'revirta') ),
				"class" => "revirta_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'revirta') ),
				"class" => "revirta_column-1_2 revirta_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'revirta') ),
				"class" => "revirta_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "image"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'revirta'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'revirta'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'revirta'),
				"desc" => wp_kses_data( __('Select width of the body content', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'revirta')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => revirta_get_list_body_styles(),
				"type" => "select"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'revirta') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'revirta')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'revirta'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'revirta')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'revirta'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'revirta'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'revirta'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'revirta'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'revirta') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'revirta'),
				"desc" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'revirta'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'revirta'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'revirta'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'revirta'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'revirta')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'revirta'),
				"desc" => '',
				"type" => "info",
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'revirta'),
				"desc" => wp_kses_data( __('Specify the border radius of the form fields and buttons in pixels or other valid CSS units', 'revirta') ),
				"std" => 0,
				"type" => "text"
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'revirta'),
				"desc" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'revirta'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'revirta') ),
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
		
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'revirta'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'revirta'),
				"desc" => '',
				"type" => "info"
				),
			'header_type' => array(
				"title" => esc_html__('Header style', 'revirta'),
				"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => 'default',
				"options" => revirta_get_list_header_footer_types(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
				),
			'header_style' => array(
				"title" => esc_html__('Select custom layout', 'revirta'),
				"desc" => wp_kses_post( __("Select custom header from Layouts Builder", 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"dependency" => array(
					'header_type' => array('custom')
				),
				"std" => REVIRTA_THEME_FREE ? 'header-default' : 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'revirta'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => 'default',
				"options" => array(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'revirta'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_zoom' => array(
				"title" => esc_html__('Header zoom', 'revirta'),
				"desc" => wp_kses_data( __("Zoom the header title. 1 - original size", 'revirta') ),
				"std" => 1,
				"min" => 0.3,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "slider"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'revirta'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 1,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'revirta'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'revirta') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'revirta'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'revirta') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'revirta'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"dependency" => array(
					'header_type' => array('default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => revirta_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'revirta'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'revirta') ),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'revirta'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'revirta'),
					'left'	=> esc_html__('Left',	'revirta'),
					'right'	=> esc_html__('Right',	'revirta')
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'revirta'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'revirta'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'revirta')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'revirta'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'revirta') ),
				"std" => 1,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'revirta'),
				"desc" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'revirta'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'revirta') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_mobile_info' => array(
				"title" => esc_html__('Mobile header', 'revirta'),
				"desc" => wp_kses_data( __("Configure the mobile version of the header", 'revirta') ),
				"priority" => 500,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "info"
				),
			'header_mobile_enabled' => array(
				"title" => esc_html__('Enable the mobile header', 'revirta'),
				"desc" => wp_kses_data( __("Use the mobile version of the header (if checked) or relayout the current header on mobile devices", 'revirta') ),
				"std" => 0,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_additional_info' => array(
				"title" => esc_html__('Additional info', 'revirta'),
				"desc" => wp_kses_data( __('Additional info to show at the top of the mobile header', 'revirta') ),
				"std" => '',
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"refresh" => false,
				"teeny" => false,
				"rows" => 20,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "text_editor"
				),
			'header_mobile_hide_info' => array(
				"title" => esc_html__('Hide additional info', 'revirta'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_logo' => array(
				"title" => esc_html__('Hide logo', 'revirta'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_login' => array(
				"title" => esc_html__('Hide login/logout', 'revirta'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_search' => array(
				"title" => esc_html__('Hide search', 'revirta'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_cart' => array(
				"title" => esc_html__('Hide cart', 'revirta'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
				),


		
			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'revirta'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_type' => array(
				"title" => esc_html__('Footer style', 'revirta'),
				"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'revirta')
				),
				"std" => 'default',
				"options" => revirta_get_list_header_footer_types(),
				"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
				),
			'footer_style' => array(
				"title" => esc_html__('Select custom layout', 'revirta'),
				"desc" => wp_kses_post( __("Select custom footer from Layouts Builder", 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'revirta')
				),
				"dependency" => array(
					'footer_type' => array('custom')
				),
				"std" => REVIRTA_THEME_FREE ? 'footer-default' : 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'revirta'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'revirta')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'revirta'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'revirta')
				),
				"dependency" => array(
					'footer_type' => array('default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => revirta_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'revirta'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'revirta') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'revirta')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'revirta'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'revirta') ),
				'refresh' => false,
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'revirta') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1)
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'revirta') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1),
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'revirta'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'revirta') ),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'revirta'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'revirta') ),
				"std" => esc_html__('Copyright &copy; {Y} by Revirta. All rights reserved.', 'revirta'),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'revirta'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'revirta') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'revirta'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'revirta') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'revirta'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'revirta'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'revirta'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'revirta'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'revirta') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'revirta'),
						'fullpost'	=> esc_html__('Full post',	'revirta')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'revirta'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'revirta') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 39,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'revirta'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'revirta') ),
					"std" => 2,
					"options" => revirta_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'revirta'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'revirta'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'revirta'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'revirta'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"std" => "pages",
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'revirta'),
						'links'	=> esc_html__("Older/Newest", 'revirta'),
						'more'	=> esc_html__("Load more", 'revirta'),
						'infinite' => esc_html__("Infinite scroll", 'revirta')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'revirta'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'revirta'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'revirta'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'revirta') ),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'revirta'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'revirta') ),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'revirta'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'revirta') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'revirta'),
					"desc" => '',
					"type" => REVIRTA_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'revirta'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'revirta') ),
					"std" => 'hide',
					"options" => array(),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'revirta'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'revirta') ),
					"std" => 'hide',
					"options" => array(),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'revirta'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'revirta') ),
					"std" => 'hide',
					"options" => array(),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'revirta'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'revirta') ),
					"std" => 'hide',
					"options" => array(),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'revirta'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'revirta'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'revirta') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'revirta'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'revirta') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'revirta'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'revirta') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'revirta'),
						'columns' => esc_html__('Mini-cards',	'revirta')
					),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'revirta'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"std" => "none",
					"options" => array(),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'revirta'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page.", 'revirta') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=0|date=1|counters=1|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'revirta'),
						'date'		 => esc_html__('Post date', 'revirta'),
						'author'	 => esc_html__('Post author', 'revirta'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'revirta'),
						'share'		 => esc_html__('Share links', 'revirta'),
						'edit'		 => esc_html__('Edit link', 'revirta')
					),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "checklist"
				),
				'counters' => array(
					"title" => esc_html__('Views, Likes and Comments', 'revirta'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'revirta') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'revirta')
					),
					"dependency" => array(
						'#page_template' => array('blog.php')
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'revirta'),
						'likes' => esc_html__('Likes', 'revirta'),
						'comments' => esc_html__('Comments', 'revirta')
					),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'revirta'),
					"desc" => wp_kses_data( __('Settings of the single post', 'revirta') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'revirta'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'revirta') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'revirta')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'revirta'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'revirta') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'revirta'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'revirta') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'meta_parts_post' => array(
					"title" => esc_html__('Post meta', 'revirta'),
					"desc" => wp_kses_data( __("Meta parts for single posts.", 'revirta') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=0|date=1|counters=1|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'revirta'),
						'date'		 => esc_html__('Post date', 'revirta'),
						'author'	 => esc_html__('Post author', 'revirta'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'revirta'),
						'share'		 => esc_html__('Share links', 'revirta'),
						'edit'		 => esc_html__('Edit link', 'revirta')
					),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "checklist"
				),
				'counters_post' => array(
					"title" => esc_html__('Views, Likes and Comments', 'revirta'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'revirta') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'revirta'),
						'likes' => esc_html__('Likes', 'revirta'),
						'comments' => esc_html__('Comments', 'revirta')
					),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "checklist"
				),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'revirta'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'revirta') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'revirta'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'revirta') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'blog_single_related_info' => array(
					"title" => esc_html__('Related posts', 'revirta'),
					"desc" => '',
					"type" => "info",
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'revirta'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'revirta') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'revirta')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'revirta'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts showed.', 'revirta') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => revirta_get_list_range(1,9),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'revirta'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'revirta') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => revirta_get_list_range(1,4),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'revirta'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'revirta') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => revirta_get_list_styles(1,2),
					"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'revirta'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'revirta'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'revirta') ),
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'revirta'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'revirta')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'revirta'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'revirta')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Sidemenu Color Scheme', 'revirta'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'revirta')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'revirta'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'revirta')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'revirta'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'revirta')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'revirta'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'revirta') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'revirta'),
				"desc" => '',
				"std" => '$revirta_get_scheme_storage',
				"refresh" => false,
				"colorpicker" => "tiny",
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'revirta'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'revirta') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'revirta')
				),
				"hidden" => true,
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'revirta'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'revirta') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'revirta')
				),
				"hidden" => true,
				"std" => '',
				"type" => REVIRTA_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			// Use huge priority to call render this elements after all options!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"priority" => 10000,
				"type" => "hidden",
				),

			'last_option' => array(		// Need to manually call action to include Tiny MCE scripts
				"title" => '',
				"desc" => '',
				"std" => 1,
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'revirta'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'revirta'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'revirta') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'revirta') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'revirta'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'revirta') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'revirta') ),
				"class" => "revirta_column-1_3 revirta_new_row",
				"refresh" => false,
				"std" => '$revirta_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=revirta_get_theme_setting('max_load_fonts'); $i++) {
			if (revirta_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					"title" => esc_html(sprintf(__('Font %s', 'revirta'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'revirta'),
				"desc" => '',
				"class" => "revirta_column-1_3 revirta_new_row",
				"refresh" => false,
				"std" => '$revirta_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'revirta'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'revirta') )
							: '',
				"class" => "revirta_column-1_3",
				"refresh" => false,
				"std" => '$revirta_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'revirta'),
					'serif' => esc_html__('serif', 'revirta'),
					'sans-serif' => esc_html__('sans-serif', 'revirta'),
					'monospace' => esc_html__('monospace', 'revirta'),
					'cursive' => esc_html__('cursive', 'revirta'),
					'fantasy' => esc_html__('fantasy', 'revirta')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'revirta'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'revirta') )
								. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'revirta') )
							: '',
				"class" => "revirta_column-1_3",
				"refresh" => false,
				"std" => '$revirta_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = revirta_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html(sprintf(__('%s settings', 'revirta'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								// Translators: Add tag's name to make description
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'revirta'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'revirta'),
						'100' => esc_html__('100 (Light)', 'revirta'), 
						'200' => esc_html__('200 (Light)', 'revirta'), 
						'300' => esc_html__('300 (Thin)',  'revirta'),
						'400' => esc_html__('400 (Normal)', 'revirta'),
						'500' => esc_html__('500 (Semibold)', 'revirta'),
						'600' => esc_html__('600 (Semibold)', 'revirta'),
						'700' => esc_html__('700 (Bold)', 'revirta'),
						'800' => esc_html__('800 (Black)', 'revirta'),
						'900' => esc_html__('900 (Black)', 'revirta')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'revirta'),
						'normal' => esc_html__('Normal', 'revirta'), 
						'italic' => esc_html__('Italic', 'revirta')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'revirta'),
						'none' => esc_html__('None', 'revirta'), 
						'underline' => esc_html__('Underline', 'revirta'),
						'overline' => esc_html__('Overline', 'revirta'),
						'line-through' => esc_html__('Line-through', 'revirta')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'revirta'),
						'none' => esc_html__('None', 'revirta'), 
						'uppercase' => esc_html__('Uppercase', 'revirta'),
						'lowercase' => esc_html__('Lowercase', 'revirta'),
						'capitalize' => esc_html__('Capitalize', 'revirta')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "revirta_column-1_5",
					"refresh" => false,
					"std" => '$revirta_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters to Theme Options
		revirta_storage_set_array_before('options', 'panel_colors', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			revirta_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'revirta'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'revirta') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'revirta')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		if (!function_exists('the_custom_logo') || (isset($_REQUEST['page']) && $_REQUEST['page']=='theme_options')) {
			revirta_storage_set_array_before('options', 'logo_retina', function_exists('the_custom_logo') ? 'custom_logo' : 'logo', array(
				"title" => esc_html__('Logo', 'revirta'),
				"desc" => wp_kses_data( __('Select or upload the site logo', 'revirta') ),
				"class" => "revirta_column-1_2 revirta_new_row",
				"priority" => 60,
				"std" => '',
				"type" => "image"
				)
			);
		}
	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('revirta_options_get_list_cpt_options')) {
	function revirta_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'revirta'),
						"desc" => '',
						"type" => "info",
						),
					"header_type_{$cpt}" => array(
						"title" => esc_html__('Header style', 'revirta'),
						"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'revirta') ),
						"std" => 'inherit',
						"options" => revirta_get_list_header_footer_types(true),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'revirta'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select custom layout to display the site header on the %s pages', 'revirta'), $title) ),
						"dependency" => array(
							"header_type_{$cpt}" => array('custom')
						),
						"std" => 'inherit',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'revirta'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'revirta'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
						),
					"header_image_override_{$cpt}" => array(
						"title" => esc_html__('Header image override', 'revirta'),
						"desc" => wp_kses_data( __("Allow override the header image with the post's featured image", 'revirta') ),
						"std" => 0,
						"type" => REVIRTA_THEME_FREE ? "hidden" : "checkbox"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'revirta'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'revirta'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'revirta'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'revirta'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'revirta'), $title) ),
						"refresh" => false,
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'revirta'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'revirta'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'revirta'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'revirta') ),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'revirta'),
						"desc" => '',
						"type" => "info",
						),
					"footer_type_{$cpt}" => array(
						"title" => esc_html__('Footer style', 'revirta'),
						"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'revirta') ),
						"std" => 'inherit',
						"options" => revirta_get_list_header_footer_types(true),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "switch"
						),
					"footer_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'revirta'),
						"desc" => wp_kses_data( __('Select custom layout to display the site footer', 'revirta') ),
						"std" => 'inherit',
						"dependency" => array(
							"footer_type_{$cpt}" => array('custom')
						),
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'revirta'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'revirta') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'revirta'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'revirta') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default'),
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => revirta_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwide', 'revirta'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'revirta') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'revirta'),
						"desc" => '',
						"type" => REVIRTA_THEME_FREE ? "hidden" : "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'revirta'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'revirta') ),
						"std" => 'hide',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'revirta'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'revirta') ),
						"std" => 'hide',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'revirta'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'revirta') ),
						"std" => 'hide',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'revirta'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'revirta') ),
						"std" => 'hide',
						"options" => array(),
						"type" => REVIRTA_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('revirta_options_get_list_choises')) {
	add_filter('revirta_filter_options_get_list_choises', 'revirta_options_get_list_choises', 10, 2);
	function revirta_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = revirta_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = revirta_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (substr($id, -7) == '_scheme')
				$list = revirta_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = revirta_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = revirta_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = revirta_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = revirta_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = revirta_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = revirta_array_merge(array(0 => esc_html__('- Select category -', 'revirta')), revirta_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = revirta_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = revirta_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = revirta_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>