<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_post_id    = get_the_ID();
$revirta_post_date  = revirta_get_date();
$revirta_post_title = get_the_title();
$revirta_post_link  = get_permalink();
$revirta_post_author_id   = get_the_author_meta('ID');
$revirta_post_author_name = get_the_author_meta('display_name');
$revirta_post_author_url  = get_author_posts_url($revirta_post_author_id, '');

$revirta_args = get_query_var('revirta_args_widgets_posts');
$revirta_show_date = isset($revirta_args['show_date']) ? (int) $revirta_args['show_date'] : 1;
$revirta_show_image = isset($revirta_args['show_image']) ? (int) $revirta_args['show_image'] : 1;
$revirta_show_author = isset($revirta_args['show_author']) ? (int) $revirta_args['show_author'] : 1;
$revirta_show_counters = isset($revirta_args['show_counters']) ? (int) $revirta_args['show_counters'] : 1;
$revirta_show_categories = isset($revirta_args['show_categories']) ? (int) $revirta_args['show_categories'] : 1;

$revirta_output = revirta_storage_get('revirta_output_widgets_posts');

$revirta_post_counters_output = '';
if ( $revirta_show_counters ) {
	$revirta_post_counters_output = '<span class="post_info_item post_info_counters">'
								. revirta_get_post_counters('comments')
							. '</span>';
}


$revirta_output .= '<article class="post_item with_thumb">';

if ($revirta_show_image) {
	$revirta_post_thumb = get_the_post_thumbnail($revirta_post_id, revirta_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($revirta_post_thumb) $revirta_output .= '<div class="post_thumb">' . ($revirta_post_link ? '<a href="' . esc_url($revirta_post_link) . '">' : '') . ($revirta_post_thumb) . ($revirta_post_link ? '</a>' : '') . '</div>';
}

$revirta_output .= '<div class="post_content">'
			. ($revirta_show_categories 
					? '<div class="post_categories">'
						. revirta_get_post_categories()
						. $revirta_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($revirta_post_link ? '<a href="' . esc_url($revirta_post_link) . '">' : '') . ($revirta_post_title) . ($revirta_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('revirta_filter_get_post_info', 
								'<div class="post_info">'
									. ($revirta_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($revirta_post_link ? '<a href="' . esc_url($revirta_post_link) . '" class="post_info_date">' : '') 
											. esc_html($revirta_post_date) 
											. ($revirta_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($revirta_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'revirta') . ' ' 
											. ($revirta_post_link ? '<a href="' . esc_url($revirta_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($revirta_post_author_name) 
											. ($revirta_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$revirta_show_categories && $revirta_post_counters_output
										? $revirta_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
revirta_storage_set('revirta_output_widgets_posts', $revirta_output);
?>