<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

// Header sidebar
$revirta_header_name = revirta_get_theme_option('header_widgets');
$revirta_header_present = !revirta_is_off($revirta_header_name) && is_active_sidebar($revirta_header_name);
if ($revirta_header_present) { 
	revirta_storage_set('current_sidebar', 'header');
	$revirta_header_wide = revirta_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($revirta_header_name) ) {
		dynamic_sidebar($revirta_header_name);
	}
	$revirta_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($revirta_widgets_output)) {
		$revirta_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $revirta_widgets_output);
		$revirta_need_columns = strpos($revirta_widgets_output, 'columns_wrap')===false;
		if ($revirta_need_columns) {
			$revirta_columns = max(0, (int) revirta_get_theme_option('header_columns'));
			if ($revirta_columns == 0) $revirta_columns = min(6, max(1, substr_count($revirta_widgets_output, '<aside ')));
			if ($revirta_columns > 1)
				$revirta_widgets_output = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($revirta_columns).' widget', $revirta_widgets_output);
			else
				$revirta_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($revirta_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$revirta_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($revirta_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'revirta_action_before_sidebar' );
				revirta_show_layout($revirta_widgets_output);
				do_action( 'revirta_action_after_sidebar' );
				if ($revirta_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$revirta_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>