<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.14
 */
$revirta_header_video = revirta_get_header_video();
$revirta_embed_video = '';
if (!empty($revirta_header_video) && !revirta_is_from_uploads($revirta_header_video)) {
	if (revirta_is_youtube_url($revirta_header_video) && preg_match('/[=\/]([^=\/]*)$/', $revirta_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$revirta_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($revirta_header_video) . '[/embed]' ));
			$revirta_embed_video = revirta_make_video_autoplay($revirta_embed_video);
		} else {
			$revirta_header_video = str_replace('/watch?v=', '/embed/', $revirta_header_video);
			$revirta_header_video = revirta_add_to_url($revirta_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$revirta_embed_video = '<iframe src="' . esc_url($revirta_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php revirta_show_layout($revirta_embed_video); ?></div><?php
	}
}
?>