<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

// Page (category, tag, archive, author) title

if ( revirta_need_page_title() ) {
	revirta_sc_layouts_showed('title', true);
	revirta_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php

						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$revirta_blog_title = revirta_get_blog_title();
							$revirta_blog_title_text = $revirta_blog_title_class = $revirta_blog_title_link = $revirta_blog_title_link_text = '';
							if (is_array($revirta_blog_title)) {
								$revirta_blog_title_text = $revirta_blog_title['text'];
								$revirta_blog_title_class = !empty($revirta_blog_title['class']) ? ' '.$revirta_blog_title['class'] : '';
								$revirta_blog_title_link = !empty($revirta_blog_title['link']) ? $revirta_blog_title['link'] : '';
								$revirta_blog_title_link_text = !empty($revirta_blog_title['link_text']) ? $revirta_blog_title['link_text'] : '';
							} else
								$revirta_blog_title_text = $revirta_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($revirta_blog_title_class); ?>"><?php
								$revirta_top_icon = revirta_get_category_icon();
								if (!empty($revirta_top_icon)) {
									$revirta_attr = revirta_getimagesize($revirta_top_icon);
									?><img src="<?php echo esc_url($revirta_top_icon); ?>" alt="" <?php if (!empty($revirta_attr[3])) revirta_show_layout($revirta_attr[3]);?>><?php
								}
								echo wp_kses_data($revirta_blog_title_text);
							?></h1>
							<?php
							if (!empty($revirta_blog_title_link) && !empty($revirta_blog_title_link_text)) {
								?><a href="<?php echo esc_url($revirta_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($revirta_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'revirta_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>