<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_args = get_query_var('revirta_logo_args');

// Site logo
$revirta_logo_type   = isset($revirta_args['type']) ? $revirta_args['type'] : '';
$revirta_logo_image  = revirta_get_logo_image($revirta_logo_type);
$revirta_logo_text   = revirta_is_on(revirta_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$revirta_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($revirta_logo_image) || !empty($revirta_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($revirta_logo_image)) {
			if (empty($revirta_logo_type) && function_exists('the_custom_logo') && (int) $revirta_logo_image > 0) {
				the_custom_logo();
			} else {
				$revirta_attr = revirta_getimagesize($revirta_logo_image);
				echo '<img src="'.esc_url($revirta_logo_image).'" alt=""'.(!empty($revirta_attr[3]) ? ' '.wp_kses_data($revirta_attr[3]) : '').'>';
			}
		} else {
			revirta_show_layout(revirta_prepare_macros($revirta_logo_text), '<span class="logo_text">', '</span>');
			revirta_show_layout(revirta_prepare_macros($revirta_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>