<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */


$revirta_header_css = $revirta_header_image = '';
$revirta_header_video = revirta_get_header_video();
if (true || empty($revirta_header_video)) {
	$revirta_header_image = get_header_image();
	if (revirta_trx_addons_featured_image_override()) $revirta_header_image = revirta_get_current_mode_image($revirta_header_image);
}

?><header class="top_panel top_panel_default<?php
					echo !empty($revirta_header_image) || !empty($revirta_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($revirta_header_video!='') echo ' with_bg_video';
					if ($revirta_header_image!='') echo ' '.esc_attr(revirta_add_inline_css_class('background-image: url('.esc_url($revirta_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (revirta_is_on(revirta_get_theme_option('header_fullheight'))) echo ' header_fullheight revirta-full-height';
					?> scheme_<?php echo esc_attr(revirta_is_inherit(revirta_get_theme_option('header_scheme')) 
													? revirta_get_theme_option('color_scheme') 
													: revirta_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($revirta_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (revirta_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	get_template_part( 'templates/header-single' );

?></header>