<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.06
 */

$revirta_header_css = $revirta_header_image = '';
$revirta_header_video = revirta_get_header_video();
if (true || empty($revirta_header_video)) {
	$revirta_header_image = get_header_image();
	if (revirta_trx_addons_featured_image_override()) $revirta_header_image = revirta_get_current_mode_image($revirta_header_image);
}

$revirta_header_id = str_replace('header-custom-', '', revirta_get_theme_option("header_style"));
if ((int) $revirta_header_id == 0) {
	$revirta_header_id = revirta_get_post_id(array(
												'name' => $revirta_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$revirta_header_id = apply_filters('revirta_filter_get_translated_layout', $revirta_header_id);
}
$revirta_header_meta = get_post_meta($revirta_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($revirta_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($revirta_header_id)));
				echo !empty($revirta_header_image) || !empty($revirta_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($revirta_header_video!='') 
					echo ' with_bg_video';
				if ($revirta_header_image!='') 
					echo ' '.esc_attr(revirta_add_inline_css_class('background-image: url('.esc_url($revirta_header_image).');'));
				if (!empty($revirta_header_meta['margin']) != '') 
					echo ' '.esc_attr(revirta_add_inline_css_class('margin-bottom: '.esc_attr(revirta_prepare_css_value($revirta_header_meta['margin'])).';'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (revirta_is_on(revirta_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight revirta-full-height';
				?> scheme_<?php echo esc_attr(revirta_is_inherit(revirta_get_theme_option('header_scheme')) 
												? revirta_get_theme_option('color_scheme') 
												: revirta_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($revirta_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('revirta_action_show_layout', $revirta_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>