<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.10
 */

// Footer sidebar
$revirta_footer_name = revirta_get_theme_option('footer_widgets');
$revirta_footer_present = !revirta_is_off($revirta_footer_name) && is_active_sidebar($revirta_footer_name);
if ($revirta_footer_present) { 
	revirta_storage_set('current_sidebar', 'footer');
	$revirta_footer_wide = revirta_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($revirta_footer_name) ) {
		dynamic_sidebar($revirta_footer_name);
	}
	$revirta_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($revirta_out)) {
		$revirta_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $revirta_out);
		$revirta_need_columns = true;	//or check: strpos($revirta_out, 'columns_wrap')===false;
		if ($revirta_need_columns) {
			$revirta_columns = max(0, (int) revirta_get_theme_option('footer_columns'));
			if ($revirta_columns == 0) $revirta_columns = min(4, max(1, substr_count($revirta_out, '<aside ')));
			if ($revirta_columns > 1)
				$revirta_out = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($revirta_columns).' widget', $revirta_out);
			else
				$revirta_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($revirta_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$revirta_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($revirta_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'revirta_action_before_sidebar' );
				revirta_show_layout($revirta_out);
				do_action( 'revirta_action_after_sidebar' );
				if ($revirta_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$revirta_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>