<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.10
 */

// Logo
if (revirta_is_on(revirta_get_theme_option('logo_in_footer'))) {
	$revirta_logo_image = '';
	if (revirta_is_on(revirta_get_theme_option('logo_retina_enabled')) && revirta_get_retina_multiplier(2) > 1)
		$revirta_logo_image = revirta_get_theme_option( 'logo_footer_retina' );
	if (empty($revirta_logo_image)) 
		$revirta_logo_image = revirta_get_theme_option( 'logo_footer' );
	$revirta_logo_text   = get_bloginfo( 'name' );
	if (!empty($revirta_logo_image) || !empty($revirta_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($revirta_logo_image)) {
					$revirta_attr = revirta_getimagesize($revirta_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($revirta_logo_image).'" class="logo_footer_image" alt=""'.(!empty($revirta_attr[3]) ? ' ' . wp_kses_data($revirta_attr[3]) : '').'></a>' ;
				} else if (!empty($revirta_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($revirta_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>