<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.10
 */

$revirta_footer_scheme =  revirta_is_inherit(revirta_get_theme_option('footer_scheme')) ? revirta_get_theme_option('color_scheme') : revirta_get_theme_option('footer_scheme');
$revirta_footer_id = str_replace('footer-custom-', '', revirta_get_theme_option("footer_style"));
if ((int) $revirta_footer_id == 0) {
	$revirta_footer_id = revirta_get_post_id(array(
												'name' => $revirta_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$revirta_footer_id = apply_filters('revirta_filter_get_translated_layout', $revirta_footer_id);
}
$revirta_footer_meta = get_post_meta($revirta_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($revirta_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($revirta_footer_id))); 
						if (!empty($revirta_footer_meta['margin']) != '') 
							echo ' '.esc_attr(revirta_add_inline_css_class('margin-top: '.revirta_prepare_css_value($revirta_footer_meta['margin']).';'));
						?> scheme_<?php echo esc_attr($revirta_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('revirta_action_show_layout', $revirta_footer_id);
	?>
</footer><!-- /.footer_wrap -->
