<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0.10
 */

// Copyright area
$revirta_footer_scheme =  revirta_is_inherit(revirta_get_theme_option('footer_scheme')) ? revirta_get_theme_option('color_scheme') : revirta_get_theme_option('footer_scheme');
$revirta_copyright_scheme = revirta_is_inherit(revirta_get_theme_option('copyright_scheme')) ? $revirta_footer_scheme : revirta_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($revirta_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$revirta_copyright = revirta_prepare_macros(revirta_get_theme_option('copyright'));
				if (!empty($revirta_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $revirta_copyright, $revirta_matches)) {
						$revirta_copyright = str_replace($revirta_matches[1], date_i18n(str_replace(array('{', '}'), '', $revirta_matches[1])), $revirta_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($revirta_copyright));
				}
			?></div>
		</div>
	</div>
</div>
