<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

if (revirta_sidebar_present()) {
	ob_start();
	$revirta_sidebar_name = revirta_get_theme_option('sidebar_widgets');
	revirta_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($revirta_sidebar_name) ) {
		dynamic_sidebar($revirta_sidebar_name);
	}
	$revirta_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($revirta_out)) {
		$revirta_sidebar_position = revirta_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($revirta_sidebar_position); ?> widget_area<?php if (!revirta_is_inherit(revirta_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(revirta_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'revirta_action_before_sidebar' );
				revirta_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $revirta_out));
				do_action( 'revirta_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>