<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('revirta_trx_addons_get_mycss')) {
	add_filter('revirta_filter_get_css', 'revirta_trx_addons_get_mycss', 10, 4);
	function revirta_trx_addons_get_mycss($css, $colors, $fonts, $scheme='') {

        if (isset($css['fonts']) && $fonts) {
            $css['fonts'] .= <<<CSS

CSS;
        }

        if (isset($css['colors']) && $colors) {
            $css['colors'] .= <<<CSS
            
            /* Inline colors */
            .trx_addons_accent,
            .trx_addons_accent_big,
            .trx_addons_accent > a,
            .trx_addons_accent > * {
                color: {$colors['text_link']};
            }
            .trx_addons_accent_hovered,
            .trx_addons_accent_hovered,
            .trx_addons_accent_hovered > a,
            .trx_addons_accent_hovered > * {
                color: {$colors['text_hover']};
            }
            .trx_addons_accent_bg {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }

            
            /* Tooltip */
            .trx_addons_tooltip {
                color: {$colors['text']};
                border-color: {$colors['text']};
            }
            .trx_addons_tooltip:before {
                background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_tooltip:after {
                border-top-color: {$colors['text_dark']};
            }
            
            
            /* Dropcaps */
            .trx_addons_dropcap_style_1 {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_dropcap_style_2 {
               background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            
            
            /* Blockqoute */
            blockquote {
                color: {$colors['inverse_link']};
                background: {$colors['text_link']};
            }
            blockquote cite a,
            blockquote > a, blockquote > p > a,
            blockquote > cite, blockquote > p > cite {
                color: {$colors['inverse_link']};
            }
            blockquote cite a:hover,
            blockquote > a, blockquote > p > a:hover {
                color: {$colors['text_hover']};
            }
            blockquote:before {
                color: {$colors['inverse_link_05']};
            }
            
            /* Images */
            figure figcaption,
            .wp-caption .wp-caption-text,
            .wp-caption .wp-caption-dd,
            .wp-caption-overlay .wp-caption .wp-caption-text,
            .wp-caption-overlay .wp-caption .wp-caption-dd {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_dark_075']};
                border-color: {$colors['text_link']};
            }
            
            
            /* Lists */
            ol li,
            ul[class*="trx_addons_list"] {
                color: {$colors['text']};
            }
            ul[class*="trx_addons_list"] > li:before{
                color: {$colors['text_link']};
            }
            ul[class*="trx_addons_list_custom"] > li:before {
                color: {$colors['text_link']};
                background-color: {$colors['bg_color_0']};
            }
            ul[class*="trx_addons_list"][class*="trx_addons_list_custom"] li:before {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link']};
            }
          
            
            /* Table */
            table th {
                color: {$colors['text']};
                background-color: {$colors['extra_bg_color']};
            }
            table th, table th + th, table td + th  {
                border-color: {$colors['extra_bd_color']};
            }
            table td, table th + td, table td + td {
                color: {$colors['text']};
                border-color: {$colors['bd_color']};
            }
            table > tbody > tr:nth-child(2n+1) > td {
                background-color: {$colors['alter_bg_hover']};
            }
            table > tbody > tr:nth-child(2n) > td {
                background-color: {$colors['alter_bg_color']};
            }

            /* Main menu */
            .sc_layouts_menu_nav>li>a {
                color: {$colors['alter_light']} !important;
            }
            .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li.current-menu-item>a,
            .sc_layouts_menu_nav>li.current-menu-parent>a,
            .sc_layouts_menu_nav>li.current-menu-ancestor>a {
                color: {$colors['text_dark']} !important;
            }
            
            /* Dropdown menu */
            .sc_layouts_menu_nav>li ul,
            .scheme_dark .sc_layouts_menu_nav>li ul{
                background-color: {$colors['alter_bg_color']};
                border-color: {$colors['text_link']};
            }
            .scheme_dark .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a, .scheme_dark .sc_layouts_menu_nav>li li>a,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a,
            .sc_layouts_menu_nav>li li>a {
                color: {$colors['alter_text']} !important;
            }
            .scheme_dark .sc_layouts_menu_nav>li li>a:hover:after, .scheme_dark .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a:hover, .scheme_dark .sc_layouts_menu_popup .sc_layouts_menu_nav>li.sfHover>a, .scheme_dark .sc_layouts_menu_nav>li li>a:hover, .scheme_dark .sc_layouts_menu_nav>li li.sfHover>a, .scheme_dark .sc_layouts_menu_nav>li li.current-menu-item>a, .scheme_dark .sc_layouts_menu_nav>li li.current-menu-parent>a, .scheme_dark .sc_layouts_menu_nav>li li.current-menu-ancestor>a,
            .sc_layouts_menu_nav>li li>a:hover:after,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li li>a:hover,
            .sc_layouts_menu_nav>li li.sfHover>a,
            .sc_layouts_menu_nav>li li.current-menu-item>a,
            .sc_layouts_menu_nav>li li.current-menu-parent>a,
            .sc_layouts_menu_nav>li li.current-menu-ancestor>a {
                color: {$colors['text_dark']} !important;
                background-color: {$colors['bg_color_0']};
            }
            
            /* Breadcrumbs */
            .sc_layouts_title_caption {
                color: {$colors['text_dark']};
            }
            .sc_layouts_title_breadcrumbs,
            .sc_layouts_title_breadcrumbs a {
                color: {$colors['text_dark_05']} !important;
            }
            .breadcrumbs_item.current{
                color: {$colors['text_dark_05']} !important;
            }
            .sc_layouts_title_breadcrumbs a:hover {
                color: {$colors['text_link']} !important;
            }
            
            /* Slider */
            .sc_slider_controls .slider_controls_wrap > a,
            .slider_container.slider_controls_side .slider_controls_wrap > a,
            .slider_outer_controls_side .slider_controls_wrap > a {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link']};
            }
            .sc_slider_controls .slider_controls_wrap > a.swiper-button-next ,
            .slider_container.slider_controls_side .slider_controls_wrap > a.swiper-button-next ,
            .slider_outer_controls_side .slider_controls_wrap > a.swiper-button-next  {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link2']};
            }
            .sc_slider_controls .slider_controls_wrap > a:hover,
            .slider_container.slider_controls_side .slider_controls_wrap > a:hover,
            .slider_outer_controls_side .slider_controls_wrap > a:hover {
                 color: {$colors['inverse_link']};
                background-color: {$colors['text_hover']} !important;
            }
            
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet,
            .swiper-pagination-custom .swiper-pagination-button {
                background-color: {$colors['inverse_link']};
            }
            .swiper-pagination-custom .swiper-pagination-button.swiper-pagination-button-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet:hover,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet:hover {
                background-color: {$colors['inverse_link']};
            }
            
            
            /* Layouts */
            .sc_layouts_logo .logo_text {
                color: {$colors['text_dark']};
            }
            

            /* Shortcodes */
            .sc_skills_pie.sc_skills_compact_off .sc_skills_total {
                color: {$colors['text_link']};
            }
            .sc_skills_pie.sc_skills_compact_off .sc_skills_item_title {
                color: {$colors['text_dark']};
            }
            .sc_countdown .sc_countdown_label,
            .sc_countdown_default .sc_countdown_digits span {
                color: {$colors['text_dark']};
                background: {$colors['bg_color_0']};
            }
            
            /* Audio */
            .trx_addons_audio_player.without_cover,
            .format-audio .post_featured.without_thumb .post_audio {
                background: {$colors['extra_bg_color']};
                border-color: {$colors['extra_bg_color']};
            }
            .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current,
            .mejs-controls .mejs-time-rail .mejs-time-current {
                background: {$colors['text_link']};
            }
            .mejs-controls .mejs-button {
                background: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .mejs-controls .mejs-button:hover {
                background: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_audio_player .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total:before, 
            .trx_addons_audio_player .mejs-controls .mejs-time-rail .mejs-time-total:before {
                background: {$colors['inverse_link_01']};
            }
            .mejs-controls .mejs-time-rail .mejs-time-total,
            .mejs-controls .mejs-time-rail .mejs-time-loaded,
            .mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total {
                background: {$colors['inverse_link_01']};
            }
            .without_thumb .mejs-controls .mejs-currenttime,
            .without_thumb .mejs-controls .mejs-duration,
            .trx_addons_audio_player .mejs-container .mejs-controls .mejs-time {
                color: {$colors['inverse_link_08']};
            }
            .format-audio .post_featured .post_audio_author,
            .trx_addons_audio_player.without_cover .audio_author {
                color: {$colors['inverse_link_08']};
            }
            .format-audio .post_featured.without_thumb .post_audio_title,
            .format-audio .post_featured .post_audio_title, .trx_addons_audio_player .audio_caption {
                color: {$colors['inverse_link']};
            }
            
            
            /* Video */
            .trx_addons_video_player.with_cover .video_hover,
            .format-video .post_featured.with_thumb .post_video_hover {
                color: {$colors['inverse_link']};
                background-color: {$colors['extra_bg_color']};
            }
            .trx_addons_video_player.with_cover .video_hover:hover,
            .format-video .post_featured.with_thumb .post_video_hover:hover {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link']};
            }
            
            /* Price */
            .sc_price_item {
                color: {$colors['text_dark_08']};
                background-color: {$colors['bg_color']};
            }
            .sc_price_item:hover {
                color: {$colors['text_dark_08']};
                background-color: {$colors['bg_color']};
            }
            .sc_price_item:hover .sc_price_item_title,
            .sc_price_item .sc_price_item_title,
            .sc_price_item .sc_price_item_title a {
                color: {$colors['text_dark']};
            }
            .sc_price_item:hover .sc_price_item_title a {
                color: {$colors['text_link']};
            }
            .sc_price_item .sc_price_item_price {
                color: {$colors['extra_text']};
                background: {$colors['bg_color']};
            }
            .sc_price_item .sc_price_item_price .sc_price_item_price_value {
                color: {$colors['text_link']};
            }
            .sc_price_item .sc_price_item_description{
                color: {$colors['text_dark']};
                border-color: {$colors['bd_color']};
            }
            .sc_price_item .sc_price_item_details {
                color: {$colors['text_dark_08']};
            }
            .sc_item_title_style_bline:before,
            .sc_services_light .sc_services_item_number:before,
            .post_item_single .post_content > .post_meta_single:before,
            .post_layout_excerpt .post_title:before,
            .widget .widget_title:before,
            .widget .widgettitle:before {
                background: {$colors['text_dark_01']};
            }
            .sc_item_title_style_bline:after,
            .sc_services_light .sc_services_item_number:after,
            .post_item_single .post_content > .post_meta_single:after,
            .post_layout_excerpt .post_title:after,
            .widget .widget_title:after,
            .widget .widgettitle:after {
                background: {$colors['text_link']};
            }
            .comments_list_wrap .comment_posted {
                color: {$colors['text_dark_08']};
            }
            .scheme_self.sidebar .sidebar_inner .widget.widget_search{
                background-color: {$colors['extra_bg_color']};
                color: {$colors['inverse_link']};
            }
            .scheme_self.sidebar .sidebar_inner .widget.widget_search .widget_title{
                color: {$colors['inverse_link']};
            }
            .scheme_self.sidebar .sidebar_inner .widget.widget_search .widget_title:before{
                background: {$colors['inverse_link_01']} !important;
            }
            .sidebar[class*="scheme_"] .widget.widget_search input.search-submit {
                background: {$colors['text_link']} !important;
            }
            .sidebar[class*="scheme_"] .widget.widget_search input.search-submit:hover {
                background: {$colors['text_link_07']} !important;
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:after {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:hover:after {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"] {
                background-color: {$colors['extra_bg_hover']};
                color: {$colors['inverse_link']};
                border-color: {$colors['extra_bg_hover']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-webkit-input-placeholder {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-moz-placeholder {
                color: {$colors['inverse_link']};
            }
            .scheme_self.footer_wrap a.social_item_type_names,
            .scheme_self.footer_wrap .widget li a {
                color: {$colors['text']};
            }
            .scheme_self.footer_wrap a.social_item_type_names:hover,
            .scheme_self.footer_wrap .widget li a:hover {
                color: {$colors['text_link']};
            }
            
            .post-top .post_meta_item.post_categories {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .post-top .post_meta_item.post_categories a {
                color: {$colors['inverse_link']};
            }
            .post-top .post_meta_item.post_categories a:hover {
                color: {$colors['inverse_link_08']};
            }
            .post_featured.hover_icon .mask {
                background-color: {$colors['text_dark_08']};
            }
            .comments_list_wrap .comment_reply a:hover,
            .post_layout_excerpt .more-link {
                background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .comments_list_wrap .comment_reply a,
            .post_layout_excerpt .more-link:hover {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark .post_item_single .post_content>.post_meta_single:after, .scheme_dark .post_layout_excerpt .post_title:after, .scheme_dark .widget .widget_title:after, .scheme_dark .widget .widgettitle:after {
                background-color: {$colors['inverse_link']};
            }
            .widget_contacts .contacts_info>div>a:before,
            .widget_contacts .contacts_info>a:before,
            .widget_contacts .contacts_info span:before,
            .widget_contacts .contacts_info {
                color: {$colors['text_dark']};
            }
            .widget_contacts .contacts_info span a:hover,
            .widget_contacts .contacts_info > a:hover {
                color: {$colors['text_dark_07']};
            }
            .scheme_dark .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image),
            .scheme_dark .socials_wrap .social_item .social_icon {
                background-color: {$colors['inverse_link']};
                color: {$colors['text_link']};
            }
            .scheme_dark .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover,
            .scheme_dark .socials_wrap .social_item:hover .social_icon {
                background-color: {$colors['text_hover']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_item_subtitle {
                color: {$colors['inverse_link']};
            }
            .scheme_dark ul[class*="trx_addons_list"][class*="trx_addons_list_custom"]{
                color: {$colors['inverse_link']};
            }
            .sc_button.sc_button_b_icon {
                background-color: {$colors['bg_color_0']} !important;
                color: {$colors['text_dark']} !important;
            }
            .sc_button.sc_button_b_icon:hover {
                background-color: {$colors['bg_color_0']} !important;
                color: {$colors['text_dark']} !important;
            }
            .sc_button.sc_button_b_icon .sc_button_icon {
                border-color: {$colors['text_dark_03']};
            }
            .team_member_page .team_member_socials .social_item:hover .social_icon,
            .sc_button.sc_button_b_icon:hover .sc_button_icon {
                border-color: {$colors['text_dark']};
                background-color: {$colors['text_dark']};
                color: {$colors['bg_color']};
            }
            .scheme_dark ul[class*="trx_addons_list"][class*="trx_addons_list_custom"] li:before {
                background-color: {$colors['inverse_link']};
                color: {$colors['text_link']};
            }
            .sc_services_light .sc_services_item_number {
                color: {$colors['text_link']};
            }
            .sc_content_border {
                border-color: {$colors['text_link']};
            }
            .team_member_page .team_member_socials .social_item,
            .sc_team_default .sc_team_item_socials .social_item,
            .sc_services_light .sc_services_item_icon {
                color: {$colors['bg_color_0']} !important;
            }
            .post_item_single .post_content > .post_meta_single .post_share .social_item {
                color: {$colors['inverse_link']} !important;
            }
            .sc_services_light .sc_services_item_icon:before {
                color: {$colors['text_link']};
            }
            .sc_services_light .sc_services_item_icon:after {
                color: {$colors['alter_bg_color']};
            }
            .sc_services_item_content {
                color: {$colors['text_dark_08']};
            }
            .sc_services_light .sc_services_item_featured_left .sc_services_item_button a,
            .sc_services_light .sc_services_item_featured_right .sc_services_item_button a,
            .scheme_dark .sc_services_light .sc_services_item_icon:before {
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_services_light .sc_services_item_title a:hover {
                color: {$colors['inverse_link_07']};
            }
            .sc_team_default .sc_team_item_subtitle,
            .sc_team_default .sc_team_item {
                color: {$colors['text_dark_08']};
                background-color: {$colors['bg_color_0']};
            }
            .scheme_dark .sc_team_default .sc_team_item_socials .social_item .social_icon {
                background-color: {$colors['inverse_link_05']};
                color: {$colors['text_link']} !important;
            }
            .scheme_dark .sc_team_default .sc_team_item_socials .social_item:hover .social_icon {
                background-color: {$colors['inverse_link']};
                color: {$colors['text_link']} !important;
            }
            .sc_team_default .sc_team_item_subtitle:before {
                background-color: {$colors['text_dark_05']};
            }
            .scheme_dark .post_featured.hover_icon .mask {
                background-color: {$colors['text_dark_08']};
            }
            .sc_testimonials [class*="column"] .sc_testimonials_item_content {
                color: {$colors['text_dark_08']};
            }
            .sc_testimonials_item_content:after {
                color: {$colors['text_link']};
            }
            .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};
            }
            
            
            .sc_testimonials .sc_slider_controls .slider_controls_wrap > a,
            .sc_testimonials .slider_container.slider_controls_side .slider_controls_wrap > a,
            .sc_testimonials .slider_outer_controls_side .slider_controls_wrap > a {
                color: {$colors['text_dark_04']};
                background-color: {$colors['bg_color_0']};
            }
            .sc_testimonials .sc_slider_controls .slider_controls_wrap > a.swiper-button-next ,
            .sc_testimonials .slider_container.slider_controls_side .slider_controls_wrap > a.swiper-button-next ,
            .sc_testimonials .slider_outer_controls_side .slider_controls_wrap > a.swiper-button-next  {
                color: {$colors['text_dark_04']};
                background-color: {$colors['bg_color_0']};
            }
            .sc_testimonials .sc_slider_controls .slider_controls_wrap > a:hover,
            .sc_testimonials .slider_container.slider_controls_side .slider_controls_wrap > a:hover,
            .sc_testimonials .slider_outer_controls_side .slider_controls_wrap > a:hover {
                 color: {$colors['text_link']};
                background-color: {$colors['bg_color_0']} !important;
            }
            .SocialsSlider a {
                color: {$colors['inverse_link']};
            }
            .SocialsSlider a:hover {
                color: {$colors['inverse_link_07']};
            }
            .custom.tparrows {
                color: {$colors['inverse_link']};
                background-color: {$colors['bg_color_0']} !important;
            }
            .custom.tparrows:before {
                color: {$colors['inverse_link']};
                background-color: {$colors['bg_color_0']} !important;
            }
            .custom.tparrows:hover:before {
                color: {$colors['text_link']};
                background-color: {$colors['bg_color_0']} !important;
            }
            .sc_item_subtitle.sc_item_title_style_gsub {
                color: {$colors['text_link']} !important;
            }
            .team_member_page .team_member_socials .social_item .social_icon,
            .scheme_self.sc_title_gsub .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image) {
                 background-color: {$colors['text_link']};
                 color: {$colors['inverse_link']};
            } 
            .scheme_self.sc_title_gsub .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover {
                 background-color: {$colors['inverse_link']};
                 color: {$colors['bg_color']} !important;
            } 
            .scheme_dark .sc_services_list .sc_services_item_icon,
            .sc_services_light .sc_services_item:hover .sc_services_item_icon {
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_services_list .sc_services_item_title a :hover,
            .scheme_dark .sc_services_list .sc_services_item:hover .sc_services_item_icon {
                color: {$colors['text_dark']};
            }
            .sc_services_light .sc_services_item:hover .sc_services_item_icon:after {
                color: {$colors['text_link']};
            }
            .sc_services_light .sc_services_item:hover .sc_services_item_icon:before {
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_team_default .sc_team_item_title a:hover {
                color: {$colors['text_dark']};
            }
            .sc_price_item_info:hover {
                border-color: {$colors['text_link']};
            }
            
CSS;
		}

		return $css;
	}
}
?>