<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('revirta_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'revirta_revslider_theme_setup9', 9 );
	function revirta_revslider_theme_setup9() {
		if (revirta_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'revirta_revslider_frontend_scripts', 1100 );
			add_filter( 'revirta_filter_merge_styles',			'revirta_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'revirta_filter_tgmpa_required_plugins','revirta_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'revirta_revslider_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('revirta_filter_tgmpa_required_plugins',	'revirta_revslider_tgmpa_required_plugins');
	function revirta_revslider_tgmpa_required_plugins($list=array()) {
		if (revirta_storage_isset('required_plugins', 'revslider')) {
			$path = revirta_get_file_dir('plugins/revslider/revslider.zip');
			if (!empty($path) || revirta_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
					'name' 		=> revirta_storage_get_array('required_plugins', 'revslider'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'revirta_exists_revslider' ) ) {
	function revirta_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'revirta_revslider_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'revirta_revslider_frontend_scripts', 1100 );
	function revirta_revslider_frontend_scripts() {
		if (revirta_is_on(revirta_get_theme_option('debug_mode')) && revirta_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'revirta-revslider',  revirta_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'revirta_revslider_merge_styles' ) ) {
	//Handler of the add_filter('revirta_filter_merge_styles', 'revirta_revslider_merge_styles');
	function revirta_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>