<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

revirta_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	revirta_show_layout(get_query_var('blog_archive_start'));

	$revirta_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$revirta_sticky_out = revirta_get_theme_option('sticky_style')=='columns' 
							&& is_array($revirta_stickies) && count($revirta_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$revirta_cat = revirta_get_theme_option('parent_cat');
	$revirta_post_type = revirta_get_theme_option('post_type');
	$revirta_taxonomy = revirta_get_post_type_taxonomy($revirta_post_type);
	$revirta_show_filters = revirta_get_theme_option('show_filters');
	$revirta_tabs = array();
	if (!revirta_is_off($revirta_show_filters)) {
		$revirta_args = array(
			'type'			=> $revirta_post_type,
			'child_of'		=> $revirta_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $revirta_taxonomy,
			'pad_counts'	=> false
		);
		$revirta_portfolio_list = get_terms($revirta_args);
		if (is_array($revirta_portfolio_list) && count($revirta_portfolio_list) > 0) {
			$revirta_tabs[$revirta_cat] = esc_html__('All', 'revirta');
			foreach ($revirta_portfolio_list as $revirta_term) {
				if (isset($revirta_term->term_id)) $revirta_tabs[$revirta_term->term_id] = $revirta_term->name;
			}
		}
	}
	if (count($revirta_tabs) > 0) {
		$revirta_portfolio_filters_ajax = true;
		$revirta_portfolio_filters_active = $revirta_cat;
		$revirta_portfolio_filters_id = 'portfolio_filters';
		?>
		<div class="portfolio_filters revirta_tabs revirta_tabs_ajax">
			<ul class="portfolio_titles revirta_tabs_titles">
				<?php
				foreach ($revirta_tabs as $revirta_id=>$revirta_title) {
					?><li><a href="<?php echo esc_url(revirta_get_hash_link(sprintf('#%s_%s_content', $revirta_portfolio_filters_id, $revirta_id))); ?>" data-tab="<?php echo esc_attr($revirta_id); ?>"><?php echo esc_html($revirta_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$revirta_ppp = revirta_get_theme_option('posts_per_page');
			if (revirta_is_inherit($revirta_ppp)) $revirta_ppp = '';
			foreach ($revirta_tabs as $revirta_id=>$revirta_title) {
				$revirta_portfolio_need_content = $revirta_id==$revirta_portfolio_filters_active || !$revirta_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $revirta_portfolio_filters_id, $revirta_id)); ?>"
					class="portfolio_content revirta_tabs_content"
					data-blog-template="<?php echo esc_attr(revirta_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(revirta_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($revirta_ppp); ?>"
					data-post-type="<?php echo esc_attr($revirta_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($revirta_taxonomy); ?>"
					data-cat="<?php echo esc_attr($revirta_id); ?>"
					data-parent-cat="<?php echo esc_attr($revirta_cat); ?>"
					data-need-content="<?php echo (false===$revirta_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($revirta_portfolio_need_content) 
						revirta_show_portfolio_posts(array(
							'cat' => $revirta_id,
							'parent_cat' => $revirta_cat,
							'taxonomy' => $revirta_taxonomy,
							'post_type' => $revirta_post_type,
							'page' => 1,
							'sticky' => $revirta_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		revirta_show_portfolio_posts(array(
			'cat' => $revirta_cat,
			'parent_cat' => $revirta_cat,
			'taxonomy' => $revirta_taxonomy,
			'post_type' => $revirta_post_type,
			'page' => 1,
			'sticky' => $revirta_sticky_out
			)
		);
	}

	revirta_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>