<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

revirta_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	revirta_show_layout(get_query_var('blog_archive_start'));

	$revirta_classes = 'posts_container '
						. (substr(revirta_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap columns_padding_bottom' : 'masonry_wrap');
	$revirta_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$revirta_sticky_out = revirta_get_theme_option('sticky_style')=='columns' 
							&& is_array($revirta_stickies) && count($revirta_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($revirta_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$revirta_sticky_out) {
		if (revirta_get_theme_option('first_post_large') && !is_paged() && !in_array(revirta_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($revirta_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($revirta_sticky_out && !is_sticky()) {
			$revirta_sticky_out = false;
			?></div><div class="<?php echo esc_attr($revirta_classes); ?>"><?php
		}
		get_template_part( 'content', $revirta_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	revirta_show_pagination();

	revirta_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>