<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($revirta_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($revirta_post_format) ); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	revirta_show_post_featured(array(
		'thumb_size' => revirta_get_thumb_size($revirta_columns==1 ? 'big' : ($revirta_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($revirta_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(), 'sticky', $revirta_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>