<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_blog_style = explode('_', revirta_get_theme_option('blog_style'));
$revirta_columns = empty($revirta_blog_style[1]) ? 2 : max(2, $revirta_blog_style[1]);
$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($revirta_columns).' post_format_'.esc_attr($revirta_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$revirta_image_hover = revirta_get_theme_option('image_hover');
	// Featured image
	revirta_show_post_featured(array(
		'thumb_size' => revirta_get_thumb_size(strpos(revirta_get_theme_option('body_style'), 'full')!==false || $revirta_columns < 3 
								? 'masonry-big' 
								: 'masonry'),
		'show_no_image' => true,
		'class' => $revirta_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $revirta_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>