<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_blog_style = explode('_', revirta_get_theme_option('blog_style'));
$revirta_columns = empty($revirta_blog_style[1]) ? 2 : max(2, $revirta_blog_style[1]);
$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');
$revirta_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($revirta_columns).' post_format_'.esc_attr($revirta_post_format) ); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($revirta_image[1]) && !empty($revirta_image[2])) echo intval($revirta_image[1]) .'x' . intval($revirta_image[2]); ?>"
	data-src="<?php if (!empty($revirta_image[0])) echo esc_url($revirta_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$revirta_image_hover = 'icon';	//revirta_get_theme_option('image_hover');
	if (in_array($revirta_image_hover, array('icons', 'zoom'))) $revirta_image_hover = 'dots';
	$revirta_components = revirta_is_inherit(revirta_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: revirta_array_get_keys_by_value(revirta_get_theme_option('meta_parts'));
	$revirta_counters = revirta_is_inherit(revirta_get_theme_option_from_meta('counters')) 
								? 'comments'
								: revirta_array_get_keys_by_value(revirta_get_theme_option('counters'));
	revirta_show_post_featured(array(
		'hover' => $revirta_image_hover,
		'thumb_size' => revirta_get_thumb_size( strpos(revirta_get_theme_option('body_style'), 'full')!==false || $revirta_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($revirta_components)
										? revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
											'components' => $revirta_components,
											'counters' => $revirta_counters,
											'seo' => false,
											'echo' => false
											), $revirta_blog_style[0], $revirta_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'revirta') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>