<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($revirta_post_format) ); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}



    ?><div class="post-top"><?php
        // Featured image
        revirta_show_post_featured(array( 'thumb_size' => revirta_get_thumb_size( strpos(revirta_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

        if (!in_array($revirta_post_format, array('audio')) ) {
            $revirta_components = 'categories';
            if (!empty($revirta_components))
                revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
                        'components' => $revirta_components,
                        'counters' => '',
                        'seo' => false
                    ), 'excerpt', 1)
                );
        }
        ?></div><?php



	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('revirta_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('revirta_action_before_post_meta'); 

			// Post meta
			$revirta_components = revirta_is_inherit(revirta_get_theme_option_from_meta('meta_parts')) 
										? 'date,counters'
										: revirta_array_get_keys_by_value(revirta_get_theme_option('meta_parts'));
			$revirta_counters = revirta_is_inherit(revirta_get_theme_option_from_meta('counters')) 
										? 'comments'
										: revirta_array_get_keys_by_value(revirta_get_theme_option('counters'));

			if (!empty($revirta_components))
				revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
					'components' => $revirta_components,
					'counters' => $revirta_counters,
					'seo' => false
					), 'excerpt', 1)
				);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (revirta_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'revirta' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'revirta' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$revirta_show_learn_more = !in_array($revirta_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($revirta_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($revirta_post_format == 'quote') {
					if (($quote = revirta_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						revirta_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $revirta_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'revirta'); ?></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>