<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_blog_style = explode('_', revirta_get_theme_option('blog_style'));
$revirta_columns = empty($revirta_blog_style[1]) ? 2 : max(2, $revirta_blog_style[1]);
$revirta_expanded = !revirta_sidebar_present() && revirta_is_on(revirta_get_theme_option('expand_content'));
$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');
$revirta_components = revirta_is_inherit(revirta_get_theme_option_from_meta('meta_parts')) 
							? 'date'
							: revirta_array_get_keys_by_value(revirta_get_theme_option('meta_parts'));
$revirta_counters = revirta_is_inherit(revirta_get_theme_option_from_meta('counters')) 
							? 'comments'
							: revirta_array_get_keys_by_value(revirta_get_theme_option('counters'));

?><div class="<?php echo $revirta_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr($revirta_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_format_'.esc_attr($revirta_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($revirta_columns)
					. ' post_layout_'.esc_attr($revirta_blog_style[0]) 
					. ' post_layout_'.esc_attr($revirta_blog_style[0]).'_'.esc_attr($revirta_columns)
					); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	revirta_show_post_featured( array( 'thumb_size' => revirta_get_thumb_size($revirta_blog_style[0] == 'classic'
													? (strpos(revirta_get_theme_option('body_style'), 'full')!==false 
															? ( $revirta_columns > 2 ? 'big' : 'huge' )
															: (	$revirta_columns > 2
																? ($revirta_expanded ? 'med' : 'small')
																: ($revirta_expanded ? 'big' : 'med')
																)
														)
													: (strpos(revirta_get_theme_option('body_style'), 'full')!==false 
															? ( $revirta_columns > 2 ? 'masonry-big' : 'full' )
															: (	$revirta_columns <= 2 && $revirta_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($revirta_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('revirta_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('revirta_action_before_post_meta'); 

			// Post meta
			if (!empty($revirta_components))
				revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
					'components' => $revirta_components,
					'counters' => $revirta_counters,
					'seo' => false
					), $revirta_blog_style[0], $revirta_columns)
				);

			do_action('revirta_action_after_post_meta'); 
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$revirta_show_learn_more = false; //!in_array($revirta_post_format, array('link', 'aside', 'status', 'quote'));
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($revirta_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($revirta_post_format == 'quote') {
				if (($quote = revirta_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					revirta_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($revirta_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($revirta_components))
				revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
					'components' => $revirta_components,
					'counters' => $revirta_counters
					), $revirta_blog_style[0], $revirta_columns)
				);
		}
		// More button
		if ( $revirta_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'revirta'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>