<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

$revirta_blog_style = explode('_', revirta_get_theme_option('blog_style'));
$revirta_columns = empty($revirta_blog_style[1]) ? 1 : max(1, $revirta_blog_style[1]);
$revirta_expanded = !revirta_sidebar_present() && revirta_is_on(revirta_get_theme_option('expand_content'));
$revirta_post_format = get_post_format();
$revirta_post_format = empty($revirta_post_format) ? 'standard' : str_replace('post-format-', '', $revirta_post_format);
$revirta_animation = revirta_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($revirta_columns).' post_format_'.esc_attr($revirta_post_format) ); ?>
	<?php echo (!revirta_is_off($revirta_animation) ? ' data-animation="'.esc_attr(revirta_get_animation_classes($revirta_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($revirta_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.esc_attr(get_the_title()).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	revirta_show_post_featured( array(
											'class' => $revirta_columns == 1 ? 'revirta-full-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => revirta_get_thumb_size(
																	strpos(revirta_get_theme_option('body_style'), 'full')!==false
																		? ( $revirta_columns > 1 ? 'huge' : 'original' )
																		: (	$revirta_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('revirta_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('revirta_action_before_post_meta'); 

			// Post meta
			$revirta_components = revirta_is_inherit(revirta_get_theme_option_from_meta('meta_parts')) 
										? 'date'.($revirta_columns < 2 ? ',counters' : '')
										: revirta_array_get_keys_by_value(revirta_get_theme_option('meta_parts'));
			$revirta_counters = revirta_is_inherit(revirta_get_theme_option_from_meta('counters')) 
										? 'comments'
										: revirta_array_get_keys_by_value(revirta_get_theme_option('counters'));
			$revirta_post_meta = empty($revirta_components) 
										? '' 
										: revirta_show_post_meta(apply_filters('revirta_filter_post_meta_args', array(
												'components' => $revirta_components,
												'counters' => $revirta_counters,
												'seo' => false,
												'echo' => false
												), $revirta_blog_style[0], $revirta_columns)
											);
			revirta_show_layout($revirta_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$revirta_show_learn_more = !in_array($revirta_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($revirta_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($revirta_post_format == 'quote') {
					if (($quote = revirta_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						revirta_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($revirta_post_format, array('link', 'aside', 'status', 'quote'))) {
				revirta_show_layout($revirta_post_meta);
			}
			// More button
			if ( $revirta_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'revirta'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>