<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage REVIRTA
 * @since REVIRTA 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WordPress editor or any Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$revirta_content = '';
$revirta_blog_archive_mask = '%%CONTENT%%';
$revirta_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $revirta_blog_archive_mask);
if ( have_posts() ) {
	the_post();
	if (($revirta_content = apply_filters('the_content', get_the_content())) != '') {
		if (($revirta_pos = strpos($revirta_content, $revirta_blog_archive_mask)) !== false) {
			$revirta_content = preg_replace('/(\<p\>\s*)?'.$revirta_blog_archive_mask.'(\s*\<\/p\>)/i', $revirta_blog_archive_subst, $revirta_content);
		} else
			$revirta_content .= $revirta_blog_archive_subst;
		$revirta_content = explode($revirta_blog_archive_mask, $revirta_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) revirta_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$revirta_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$revirta_args = revirta_query_add_posts_and_cats($revirta_args, '', revirta_get_theme_option('post_type'), revirta_get_theme_option('parent_cat'));
$revirta_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($revirta_page_number > 1) {
	$revirta_args['paged'] = $revirta_page_number;
	$revirta_args['ignore_sticky_posts'] = true;
}
$revirta_ppp = revirta_get_theme_option('posts_per_page');
if ((int) $revirta_ppp != 0)
	$revirta_args['posts_per_page'] = (int) $revirta_ppp;
// Make a new main query
$GLOBALS['wp_the_query']->query($revirta_args);


// Add internal query vars in the new query!
if (is_array($revirta_content) && count($revirta_content) == 2) {
	set_query_var('blog_archive_start', $revirta_content[0]);
	set_query_var('blog_archive_end', $revirta_content[1]);
}

get_template_part('index');
?>